/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.lootbeams.Configuration;
import com.lootbeams.LootBeamRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.TridentItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lootbeams", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientSetup {
    public static void init(FMLClientSetupEvent e) {
        MinecraftForge.EVENT_BUS.addListener(ClientSetup::onRenderNameplate);
    }

    public static void onRenderNameplate(RenderNameplateEvent event) {
        if (event.getEntity() instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)event.getEntity();
            if (Minecraft.func_71410_x().field_71439_g.func_70068_e((Entity)itemEntity) > (Double)Configuration.RENDER_DISTANCE.get() * (Double)Configuration.RENDER_DISTANCE.get()) {
                return;
            }
            boolean shouldRender = false;
            if (((Boolean)Configuration.ALL_ITEMS.get()).booleanValue()) {
                shouldRender = true;
            } else {
                if (((Boolean)Configuration.ONLY_EQUIPMENT.get()).booleanValue()) {
                    List<Class> equipmentClasses = Arrays.asList(SwordItem.class, ToolItem.class, ArmorItem.class, ShieldItem.class, BowItem.class, CrossbowItem.class, TridentItem.class, ArrowItem.class, FishingRodItem.class);
                    for (Class item : equipmentClasses) {
                        if (!item.isAssignableFrom(itemEntity.func_92059_d().func_77973_b().getClass())) continue;
                        shouldRender = true;
                        break;
                    }
                }
                if (((Boolean)Configuration.ONLY_RARE.get()).booleanValue()) {
                    boolean bl = shouldRender = itemEntity.func_92059_d().func_77953_t() != Rarity.COMMON;
                }
                if (ClientSetup.isItemInRegistryList((List)Configuration.WHITELIST.get(), itemEntity.func_92059_d().func_77973_b())) {
                    shouldRender = true;
                }
            }
            if (ClientSetup.isItemInRegistryList((List)Configuration.BLACKLIST.get(), itemEntity.func_92059_d().func_77973_b())) {
                shouldRender = false;
            }
            if (shouldRender) {
                LootBeamRenderer.renderLootBeam(event.getMatrixStack(), event.getRenderTypeBuffer(), event.getPartialTicks(), itemEntity.field_70170_p.func_82737_E(), itemEntity);
            }
        }
    }

    private static boolean isItemInRegistryList(List<String> registryNames, Item item) {
        if (registryNames.size() > 0) {
            for (String id : registryNames.stream().filter(s -> !s.isEmpty()).collect(Collectors.toList())) {
                if (!id.contains(":") && item.getRegistryName().func_110624_b().equals(id)) {
                    return true;
                }
                ResourceLocation itemResource = ResourceLocation.func_208304_a((String)id);
                if (itemResource == null || ((Item)ForgeRegistries.ITEMS.getValue(itemResource)).getItem() != item.getItem()) continue;
                return true;
            }
        }
        return false;
    }
}

